﻿/**
 * @name 图片轮播jcarousel插件
 * @description 基于jQuery开发的一款简单的图片轮播插件，提供通用的参数、事件、方法等功能
 * @version 1.0.0
 * @author caojianping 2016/10/24
 */
; (function ($, window, document, undefined) {
    //轮播对象
    var Carousel = function (elements, options) {
        this.$elements = elements;
        this.options = options;
    };

    Carousel.prototype.constructor = Carousel;

    //轮播对象扩展方法
    Carousel.prototype = {
        //初始化
        init: function () {
            var that = this;
            return that.$elements.each(function () {
                var disabled = that.cacheData(this);
                if (disabled === false) {
                    that.setStyle(this);
                    that.bindEvents(this);
                }
            });
        },
        //缓存数据
        cacheData: function (element) {
            var that = this,
                data = $.data(element, 'jcarousel');
            if (!data) {
                data = $.extend({}, $.fn.jcarousel.defaults, that.options || {});
            } else {
                if (data.timer) {
                    //作用：停止原来的定时器timer(缓存数据中存储的定时器timer)
                    //问题：调用方法时会创建新的轮播对象，同时会导致无法获取并停止原来的定时器timer
                    //方案：采用定时器timer存入缓存数据中的策略
                    clearInterval(data.timer);
                }
                $(element).off('.jcarousel');
                $(element).find('.jcarousel-control').off('.jcarousel');
                if (touch) {
                    //看完touch源码，调试发现off功能是木有效果滴，源码中没有扩展或者封装removeEventListener
                    touch.off(element, 'touchstart touchend swipeleft swiperight');
                }
                data = $.extend(data, that.options || {});
            }
            $.data(element, 'jcarousel', data);
            return data.disabled;
        },
        //设置样式
        setStyle: function (element) {
            var that = this,
                data = $.data(element, 'jcarousel'),
                $jcarousel = $(element),
                $jcarouselList = $jcarousel.find('.jcarousel-list'),
                $jcarouselItem = $jcarousel.find('.jcarousel-list .jcarousel-item'),
                $jcarouselControl = $jcarousel.find('.jcarousel-control');

            $jcarousel.width(data.width);

            var w = $jcarousel.width() / data.imageCount,
                h = w / data.imageRatio;

            $jcarouselItem.width(w).height(h);
            $jcarouselList.width(w * $jcarouselItem.length).height(h);
            $jcarousel.height(h);
            $jcarouselControl.css('top', (h - $jcarouselControl.height()) / 2);

            if (!$jcarousel.hasClass('jcarousel')) {
                $jcarousel.addClass('jcarousel');
            }
        },
        //绑定事件
        bindEvents: function (element) {
            var that = this,
                data = $.data(element, 'jcarousel'),
                $jcarousel = $(element),
                $jcarouselControl = $jcarousel.find('.jcarousel-control');

            //自动轮播            
            if (data.autoplay === true) {
                data.timer = setInterval(function () {
                    that.move(element, 'next');
                }, data.speed);
            }

            if (data.mobile === true) {
                //绑定移动设备事件
                $jcarouselControl.hide();
                if (touch) {
                    console.log('touch:', Touch);
                    touch.on(element, 'touchstart touchend swipeleft swiperight', function (event) {
                        switch (event.type) {
                            case 'touchstart':
                                if (data.autoplay === true) {
                                    clearInterval(data.timer);
                                }
                                break;
                            case 'touchend':
                                if (data.autoplay === true) {
                                    data.timer = setInterval(function () {
                                        that.move(element, 'next');
                                    }, data.speed);
                                }
                                break;
                            case 'swipeleft':
                                that.move(element, 'next', true);
                                break;
                            case 'swiperight':
                                that.move(element, 'prev', true);
                                break;
                        }
                    });
                }
            } else {
                //绑定非移动设备事件
                $jcarousel.on('mouseover.jcarousel mouseout.jcarousel', function (event) {
                    switch (event.type) {
                        case 'mouseover':
                            if (data.autoplay === true) {
                                clearInterval(data.timer);
                            }
                            break;
                        case 'mouseout':
                            if (data.autoplay === true) {
                                data.timer = setInterval(function () {
                                    that.move(element, 'next');
                                }, data.speed);
                            }
                            break;
                    }
                });

                $jcarouselControl.on('click.jcarousel', function () {
                    if ($(this).hasClass('next')) {
                        that.move(element, 'next', true);
                    } else if ($(this).hasClass('prev')) {
                        that.move(element, 'prev', true);
                    }
                });
            }
        },
        //轮播
        move: function (element, direct, manul) {
            var that = this,
                data = $.data(element, 'jcarousel'),
                $jcarousel = $(element),
                $jcarouselList = $jcarousel.find('.jcarousel-list'),
                $jcarouselItem = $jcarousel.find('.jcarousel-item'),
                w = $jcarousel.width() / data.imageCount;

            if (direct === 'next') {
                $jcarouselList.animate({ left: '-' + w + 'px' }, manul === true ? 'fast' : 'slow', function () {
                    $jcarouselItem.first().appendTo($jcarouselList);
                    $jcarouselList.css('left', 0);
                });
            } else if (direct === 'prev') {
                $jcarouselItem.last().prependTo($jcarouselList);
                $jcarouselList.css('left', '-' + w + 'px');
                $jcarouselList.animate({ 'left': 0 }, manul === true ? 'fast' : 'slow', function () { });
            }
        }
    };

    $.fn.extend({
        jcarousel: function (options) {
            //1.插件传入配置参数；
            //2.插件传入方法名称、及方法参数；
            if (typeof options === 'string') {
                var args = Array.prototype.slice.call(arguments, 1);
                return $.fn.jcarousel.methods[options](this, args);
            }
            return new Carousel(this, options).init();
        }
    });

    //默认配置参数
    //包含：配置、事件
    $.fn.jcarousel.defaults = {
        disabled: false,//是否禁用
        width: 300,//轮播插件宽度
        imageCount: 2,//显示图片个数
        imageRatio: 2,//显示图片比例
        autoplay: false,//是否自动播放
        speed: 1000,//自动播放速度
        mobile: false,//是否支持移动设备
        timer: null,
        onStart: function () { },
        onStop: function () { },
    };

    //默认方法
    $.fn.jcarousel.methods = {
        //返回插件配置参数
        options: function (elements) {
            return $.data(elements[0], 'jcarousel');
        },
        //启用插件
        enable: function (elements) {
            return elements.each(function () {
                $(this).jcarousel({ disabled: false });
            });
        },
        //禁用插件
        disable: function (elements) {
            return elements.each(function () {
                $(this).jcarousel({ disabled: true });
            });
        },
        //控制自动播放
        auto: function (elements, args) {
            return elements.each(function () {
                $(this).jcarousel({ autoplay: Array.prototype.shift.call(args) });
            });
        }
    };
})(jQuery, window, document);